#include "build/lpc213x.h"

#define SPLC501C_SET		IOSET0
#define SPLC501C_CLR		IOCLR0
#define SPLC501C_DIR		IODIR0
#define SPLC501C_PIN		IOPIN0

// control signals
#define SPLC501C_RD		(1 << 4) 	/* pin PA8 -> E */
#define SPLC501C_WR		(1 << 5) 	/* pin PA9 -> RW */
#define SPLC501C_A0		(1 << 6) 	/* pin PA10 -> RS */
#define SPLC501C_RES  	(1 << 7) 	/* pin PA11 -> RST */
#define SPLC501C_CS1 	(1 << 8) 	/* pin PA12  -> CS1B */

// first databus bit
#define SPLC501C_D0      16 /* first databus bit is pin PA0 */

//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
void GLCD_InitializePorts(void)
{
volatile int i;

SPLC501C_SET = (SPLC501C_RD | SPLC501C_WR | SPLC501C_A0 | SPLC501C_RES | SPLC501C_CS1);
SPLC501C_DIR |= (SPLC501C_RD | SPLC501C_WR | SPLC501C_A0 | SPLC501C_RES | SPLC501C_CS1);

SPLC501C_CLR = SPLC501C_RES;
for(i = 0 ; i < 1000; i++);
SPLC501C_SET = SPLC501C_RES;

}
//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
unsigned char GLCD_ReadStatus(void)
{
unsigned char tmp;

SPLC501C_DIR &= ~(0xFF << SPLC501C_D0);

SPLC501C_CLR = (SPLC501C_RD | SPLC501C_A0 | SPLC501C_CS1);
asm("nop");
tmp = (SPLC501C_PIN >> SPLC501C_D0);
SPLC501C_SET = (SPLC501C_RD | SPLC501C_A0 | SPLC501C_CS1);

return tmp;
}
//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
unsigned char GLCD_ReadData(void)
{
unsigned char tmp;
while(GLCD_ReadStatus()&0x90);
SPLC501C_DIR &= ~(0xFF << SPLC501C_D0);

SPLC501C_CLR = (SPLC501C_RD | SPLC501C_CS1);
asm("nop");
SPLC501C_SET = (SPLC501C_RD | SPLC501C_CS1);
SPLC501C_CLR = (SPLC501C_RD | SPLC501C_CS1);
asm("nop");
tmp = (SPLC501C_PIN >> SPLC501C_D0);
SPLC501C_SET = (SPLC501C_RD | SPLC501C_CS1);

return tmp;
}
//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
void GLCD_WriteData(unsigned char dataToWrite)
{
while(GLCD_ReadStatus()&0x90);
SPLC501C_DIR |= (0xFF << SPLC501C_D0);

SPLC501C_SET = (dataToWrite << SPLC501C_D0);
dataToWrite ^= 0xFF;
SPLC501C_CLR = (dataToWrite << SPLC501C_D0);

SPLC501C_CLR = (SPLC501C_WR | SPLC501C_CS1);
asm("nop");
SPLC501C_SET = (SPLC501C_WR | SPLC501C_CS1);
}
//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
void GLCD_WriteCommand(unsigned char commandToWrite)
{
while(GLCD_ReadStatus()&0x90);
SPLC501C_DIR |= (0xFF << SPLC501C_D0);

SPLC501C_SET = (commandToWrite << SPLC501C_D0);
commandToWrite ^= 0xFF;
SPLC501C_CLR = (commandToWrite << SPLC501C_D0);

SPLC501C_CLR = (SPLC501C_WR | SPLC501C_A0 | SPLC501C_CS1);
asm("nop");
SPLC501C_SET = (SPLC501C_WR | SPLC501C_A0 | SPLC501C_CS1);
}
//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
