#include "SPLC501C.h"
#include "font5x7.h"
extern void GLCD_WriteCommand(unsigned char);
extern void GLCD_WriteData(unsigned char);
extern unsigned char GLCD_ReadData(void);
extern void GLCD_InitializePorts(void);

//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
void GLCD_Initialize(void)
{
volatile int i;
GLCD_InitializePorts();

GLCD_WriteCommand(SPLC501C_ADC_NORMAL);					
GLCD_WriteCommand(SPLC501C_COM63);	

GLCD_WriteCommand(SPLC501C_BIAS_19);						
GLCD_WriteCommand(SPLC501C_POWERON);						
for(i = 0; i < 100; i++);
GLCD_WriteCommand(SPLC501C_VOLUME_MODE);						
GLCD_WriteCommand(SPLC501C_VOLUME_SET | 20);
GLCD_WriteCommand(0xA4);						
GLCD_WriteCommand(SPLC501C_DISPLAY_ON);						
GLCD_WriteCommand(SPLC501C_DISPLAY_NORMAL);		
GLCD_WriteCommand(SPLC501C_PAGE_ADDRESS | 0);
GLCD_WriteCommand(SPLC501C_COLUMN_ADDRESS_HI | 0);		
GLCD_WriteCommand(SPLC501C_COLUMN_ADDRESS_LO | 0);
GLCD_WriteCommand(SPLC501C_START_LINE | 0);	

}
//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
void GLCD_GoTo(unsigned char x, unsigned char y)
{
GLCD_WriteCommand(SPLC501C_COLUMN_ADDRESS_HI | (x >> 4));
GLCD_WriteCommand(SPLC501C_COLUMN_ADDRESS_LO | (x & 0x0F));
GLCD_WriteCommand(SPLC501C_PAGE_ADDRESS | y);
}
//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
void GLCD_ClearScreen(void)
{
unsigned char x = 0, y = 0;
for(y = 0; y < (SCREEN_HEIGHT/PIXELS_PER_PAGE); y++)
	{
	GLCD_GoTo(0,y);
	for(x = 0; x < SCREEN_WIDTH; x++)
		{
		GLCD_WriteData(0);
		}
	}
}		
//-------------------------------------------------------------------------------------------------
// Function : GLCD_WriteChar
// Artuments : Char ASCII code
// Return value : none
//-------------------------------------------------------------------------------------------------
void GLCD_WriteChar(char charCode)
{
unsigned char fontCollumn;
for(fontCollumn = 0; fontCollumn < FONT_WIDTH; fontCollumn++)
  GLCD_WriteData(font5x7[((charCode- FONT_OFFSET) * FONT_WIDTH) + fontCollumn]);
GLCD_WriteData(0);
}
//-------------------------------------------------------------------------------------------------
// Function : GLCD_WriteString
// Arguments : pointer to null-terminated ASCII string
// Return value : none
//-------------------------------------------------------------------------------------------------
void GLCD_WriteString(char * string)
{
while(*string)
  {
  GLCD_WriteChar(*string++);
  }
}
//-------------------------------------------------------------------------------------------------
// Function : GLCD_SetPixel
// Arguments : x-location, y-location, color (0 or 1)
// Return value : None
//-------------------------------------------------------------------------------------------------
void GLCD_SetPixel(int x, int y, int color)
{
unsigned char temp = 0;  
GLCD_GoTo(x, (y/8)); 
temp = GLCD_ReadData(); 
if(color)
  temp |= (1 << (y % 8));
else
  temp &= ~(1 << (y % 8));
GLCD_GoTo(x, (y/8)); 
GLCD_WriteData(temp); 
}
//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
void GLCD_Bitmap(char * bitmap,unsigned char left, unsigned char top, unsigned char width, unsigned char height)
{
unsigned char pageIndex, columnIndex;
for(pageIndex = 0; pageIndex < height / 8; pageIndex++)
  {
  GLCD_GoTo(left, top + pageIndex);
  for(columnIndex = 0; columnIndex < width; columnIndex++)
    GLCD_WriteData(*(bitmap++)); 
  }
}
//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
